<?php

global $ulz_listing;

$owner = new \UtillzCore\Inc\Src\User( $ulz_listing->post->post_author );
$owner_userdata = get_userdata( $owner->id );
$owner_description = get_the_author_meta( 'description', $owner->id );

?>

<div class="ulz-action-author">
    <div class="ulz--avatar">
        <?php echo $owner->avatar(); ?>
        <div class="ulz--meta">
            <span class="ulz--name"><?php echo esc_html( $owner_userdata->display_name ); ?></span>
            <a href="<?php echo esc_url( get_author_posts_url( $owner->id ) ); ?>" class="ulz--view" target="_blank">
                <?php esc_html_e( 'View profile', 'utillz-core' ); ?>
            </a>
        </div>
    </div>
    <div class="ulz--content">
        <?php if( $owner_description ): ?>
            <?php echo wpautop( wp_trim_words( $owner_description, apply_filters('utillz/action/author/bio-length', 15) ) ); ?>
        <?php endif; ?>
    </div>
</div>
